<?php
// Tambahkan ini di awal Handler.php untuk debug
define('DEBUG_MODE', true);
define('DEBUG_FILE', __DIR__ . '/Module/tmp/card_debug.txt');

function debug_log($msg) {
    if (DEBUG_MODE) {
        $time = date('H:i:s.') . substr(microtime(), 2, 3);
        file_put_contents(DEBUG_FILE, "[$time] $msg\n", FILE_APPEND);
    }
}

function debug_timer($label) {
    static $timers = [];
    if (!isset($timers[$label])) {
        $timers[$label] = microtime(true);
        debug_log("START: $label");
    } else {
        $elapsed = round((microtime(true) - $timers[$label]) * 1000, 2);
        debug_log("END: $label = {$elapsed}ms");
        unset($timers[$label]);
    }
}
?>
